/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Reference;
import com.mrbysco.instrumentalmobs.config.InstrumentalConfig;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityMicrophoneWave
extends ThrowableItemProjectile {
    private SoundEvent sound = SoundEvents.f_11922_;
    private LivingEntity shootingEntity;

    public EntityMicrophoneWave(EntityType<? extends EntityMicrophoneWave> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMicrophoneWave(Level worldIn, LivingEntity throwerIn, SoundEvent theSound) {
        super((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get(), throwerIn, worldIn);
        this.shootingEntity = throwerIn;
        this.sound = theSound;
    }

    public EntityMicrophoneWave(Level worldIn, double x, double y, double z) {
        super((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get(), x, y, z, worldIn);
    }

    public EntityMicrophoneWave(PlayMessages.SpawnEntity spawnEntity, Level worldIn) {
        this((EntityType<? extends EntityMicrophoneWave>)((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get()), worldIn);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            this.soundExplosion();
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof Player && this.shootingEntity instanceof Player) {
            Player playerIn = (Player)this.shootingEntity;
            Player collidingPlayer = (Player)entity;
            if (playerIn.m_7099_(collidingPlayer) && this.f_19853_.f_46441_.nextInt(10) <= 2) {
                collidingPlayer.m_6469_(Reference.causeSoundDamage((Entity)this), 1.0f);
            }
        } else {
            entity.m_6469_(Reference.causeSoundDamage((Entity)this), 6.0f);
            this.m_19970_(this.shootingEntity, entity);
        }
    }

    public void soundExplosion() {
        this.f_19853_.m_5594_(null, this.m_142538_(), this.sound, this.m_5720_(), 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (((Boolean)InstrumentalConfig.COMMON.mobsReact.get()).booleanValue()) {
            InstrumentHelper.instrumentDamage(this.f_19853_, (LivingEntity)this.m_37282_(), this.m_142469_().m_82400_(((Double)InstrumentalConfig.COMMON.instrumentRange.get()).doubleValue()));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    protected Item m_7881_() {
        return (Item)InstrumentalRegistry.microphone.get();
    }
}

